// Meeting-based policy rule estimation 

clear

// pick the folder for data:
//cd "C:\Users\g1tjs01\Documents\brookings\1987 extension\files for final submission"
cd "D:\Projects\Brookings 2015\Taylor Rules\Data"

// load data
use meetingData

// Create quarter variable
gen strfomc = fomcdate
format %16.0f strfomc
gen strdate = string(strfomc, "%16.0f")
gen date = date(strdate, "YMD")
format date %td
drop strfomc strdate
gen fomcquarter = quarter(date)

// make sure data is time series
tsset proxy_time

// define variables for taylor rule estimation
gen corecpi_4q = (corecpi_T0 + corecpi_T1 + corecpi_T2 + corecpi_T3 )/4
gen outputgap_4q = (outputgap_T0 + outputgap_T1 + outputgap_T2 + outputgap_T3)/4
gen ffr = ffraftermeeting
replace ffr = ffr_Thornton if proxy_time<=1023  //last meeting 1989 use Thornton

// gap revision (account for some meetings in same quarter)
gen outputgap_4q_TM1 = (L.outputgap_T1 + L.outputgap_T2 + L.outputgap_T3 + L.outputgap_T4)/4 if fomcquarter != L.fomcquarter
replace outputgap_4q_TM1 = (L.outputgap_T0 + L.outputgap_T1 + L.outputgap_T2 + L.outputgap_T3)/4 if fomcquarter == L.fomcquarter
gen gap_revision = outputgap_4q-outputgap_4q_TM1
quietly summarize gap_revision 
replace gap_revision = (gap_revision-r(mean))/r(sd)

// corecpi revision (account for some meetings in same quarter)
gen corecpi_4q_TM1 = (L.corecpi_T1 + L.corecpi_T2 + L.corecpi_T3 + L.corecpi_T4)/4 if fomcquarter != L.fomcquarter
replace corecpi_4q_TM1 = (L.corecpi_T0 + L.corecpi_T1 + L.corecpi_T2 + L.corecpi_T3)/4 if fomcquarter == L.fomcquarter
gen corecpi_revision = corecpi_4q - corecpi_4q_TM1
quietly summarize corecpi_revision 
replace corecpi_revision = (corecpi_revision-r(mean))/r(sd)


// other fomc variables
// word counts
gen wordunc = 100*(mp_cond_uncertaintyactivity+mp_cond_uncertaintyinflation)
quietly summarize wordunc
replace wordunc = (wordunc-r(mean))/r(sd)

gen wordins = 100*(mp_cond_insuranceactivity+mp_cond_insuranceinflation)
quietly summarize wordins
replace wordins = (wordins-r(mean))/r(sd)
*
label variable ffr "FFR thirty-day forward average after FOMC meeting"
label variable corecpi_4q "4-quarter inflation average"
label variable outputgap_4q "4-quarter output gap average"

// Policy rule estimation

// Baseline
// 1048 is 1993mtg1
reg ffr L.ffr L2.ffr L3.ffr L4.ffr L5.ffr corecpi_4q outputgap_4q if proxy_time>=1048, robust
estat durbinalt, lags(5) force robust 
matrix input table_Min_r = (1,1,1,1,1,1,1)
matrix table_Min_r[1,1] = r(p)
nlcom (rho1: _b[L.ffr]) (rho2: _b[L2.ffr]) (rho3: _b[L3.ffr]) (rho4: _b[L4.ffr]) (rho5: _b[L5.ffr]) ///
      (beta: _b[corecpi_4q]/(1-_b[L.ffr]-_b[L2.ffr]-_b[L3.ffr]-_b[L4.ffr]-_b[L5.ffr])) ///
      (gamma: _b[outputgap_4q]/(1-_b[L.ffr]-_b[L2.ffr]-_b[L3.ffr]-_b[L4.ffr]-_b[L5.ffr])) , post
est2vec table_Min, vars(beta gamma hUnc hIns mUnc mIns frGap frInf) replace name(col1) e(r2_a a)
quietly: reg ffr L.ffr L2.ffr L3.ffr L4.ffr L5.ffr corecpi_4q outputgap_4q if proxy_time>=1048, robust
matrix table_Min_e[2,1] = e(r2_a)
matrix table_Min_e[3,1] = 5

// Human-coding

reg ffr L.ffr L2.ffr L3.ffr L4.ffr L5.ffr corecpi_4q outputgap_4q uncertlevel if proxy_time>=1048, robust 
estat durbinalt, lags(5) force robust 
matrix table_Min_r[1,2] = r(p)
nlcom (rho1: _b[L.ffr]) (rho2: _b[L2.ffr]) (rho3: _b[L3.ffr]) (rho4: _b[L4.ffr])  (rho5: _b[L5.ffr]) /// 
  (beta: _b[corecpi_4q]/(1-_b[L.ffr]-_b[L2.ffr]-_b[L3.ffr]-_b[L4.ffr]-_b[L5.ffr])) ///
  (gamma: _b[outputgap_4q]/(1-_b[L.ffr]-_b[L2.ffr]-_b[L3.ffr]-_b[L4.ffr]-_b[L5.ffr])) ///
  (hUnc: _b[uncertlevel]/(1-_b[L.ffr]-_b[L2.ffr]-_b[L3.ffr]-_b[L4.ffr]-_b[L5.ffr])), post
est2vec table_Min, addto(table_Min) name(col2)
quietly: reg ffr L.ffr L2.ffr L3.ffr L4.ffr L5.ffr corecpi_4q outputgap_4q uncertlevel if proxy_time>=1048, robust
matrix table_Min_e[2,2] = e(r2_a)
matrix table_Min_e[3,2] = 5
 
reg ffr L.ffr L2.ffr L3.ffr L4.ffr L5.ffr corecpi_4q outputgap_4q insurlevel if proxy_time>=1048, robust 
estat durbinalt, lags(5) force robust 
matrix table_Min_r[1,3] = r(p)
nlcom (rho1: _b[L.ffr]) (rho2: _b[L2.ffr]) (rho3: _b[L3.ffr]) (rho4: _b[L4.ffr])  (rho5: _b[L5.ffr]) /// 
  (beta: _b[corecpi_4q]/(1-_b[L.ffr]-_b[L2.ffr]-_b[L3.ffr]-_b[L4.ffr]-_b[L5.ffr])) ///
  (gamma: _b[outputgap_4q]/(1-_b[L.ffr]-_b[L2.ffr]-_b[L3.ffr]-_b[L4.ffr]-_b[L5.ffr])) ///
  (hIns: _b[insurlevel]/(1-_b[L.ffr]-_b[L2.ffr]-_b[L3.ffr]-_b[L4.ffr]-_b[L5.ffr])), post
est2vec table_Min, addto(table_Min) name(col3)
quietly: reg ffr L.ffr L2.ffr L3.ffr corecpi_4q outputgap_4q insurlevel if proxy_time>=1048, robust
matrix table_Min_e[2,3] = e(r2_a)
matrix table_Min_e[3,3] = 5

// Machine-coding
reg ffr L.ffr L2.ffr L3.ffr L4.ffr L5.ffr corecpi_4q outputgap_4q wordunc  if proxy_time>=1048, robust
estat durbinalt, lags(5) force robust 
matrix table_Min_r[1,4] = r(p)
nlcom (rho1: _b[L.ffr]) (rho2: _b[L2.ffr]) (rho3: _b[L3.ffr]) (rho4: _b[L4.ffr])  (rho5: _b[L5.ffr]) /// 
  (beta: _b[corecpi_4q]/(1-_b[L.ffr]-_b[L2.ffr]-_b[L3.ffr]-_b[L4.ffr]-_b[L5.ffr])) ///
  (gamma: _b[outputgap_4q]/(1-_b[L.ffr]-_b[L2.ffr]-_b[L3.ffr]-_b[L4.ffr]-_b[L5.ffr])) ///
  (mUnc: _b[wordunc]/(1-_b[L.ffr]-_b[L2.ffr]-_b[L3.ffr]-_b[L4.ffr]-_b[L5.ffr])), post
est2vec table_Min, addto(table_Min) name(col5)
quietly: reg ffr L.ffr L2.ffr L3.ffr L4.ffr L5.ffr corecpi_4q outputgap_4q wordunc if proxy_time>=1048, robust
matrix table_Min_e[2,4] = e(r2_a)
matrix table_Min_e[3,4] = 5

reg ffr L.ffr L2.ffr L3.ffr  L4.ffr L5.ffr corecpi_4q outputgap_4q wordins  if proxy_time>=1048, robust
estat durbinalt, lags(5) force robust 
matrix table_Min_r[1,5] = r(p)
nlcom (rho1: _b[L.ffr]) (rho2: _b[L2.ffr]) (rho3: _b[L3.ffr]) (rho4: _b[L4.ffr])  (rho5: _b[L5.ffr]) /// 
  (beta: _b[corecpi_4q]/(1-_b[L.ffr]-_b[L2.ffr]-_b[L3.ffr]-_b[L4.ffr]-_b[L5.ffr])) ///
  (gamma: _b[outputgap_4q]/(1-_b[L.ffr]-_b[L2.ffr]-_b[L3.ffr]-_b[L4.ffr]-_b[L5.ffr])) ///
  (mIns: _b[wordins]/(1-_b[L.ffr]-_b[L2.ffr]-_b[L3.ffr]-_b[L4.ffr]-_b[L5.ffr])), post
est2vec table_Min, addto(table_Min) name(col6)
quietly: reg ffr L.ffr L2.ffr L3.ffr L4.ffr L5.ffr corecpi_4q outputgap_4q wordins if proxy_time>=1048, robust
matrix table_Min_e[2,5] = e(r2_a)
matrix table_Min_e[3,5] = 5


// Output gap revisions  
*reg ffr L.ffr L2.ffr L3.ffr L4.ffr L5.ffr corecpi_4q outputgap_4q gap_revision if proxy_time>=1048 & proxy_time<1168, robust // exclude 2008
reg ffr L.ffr L2.ffr L3.ffr L4.ffr L5.ffr corecpi_4q outputgap_4q gap_revision if proxy_time>=1048, robust
estat durbinalt, lags(5) force robust 
matrix table_Min_r[1,6] = r(p)
nlcom (rho1: _b[L.ffr]) (rho2: _b[L2.ffr]) (rho3: _b[L3.ffr]) (rho4: _b[L4.ffr])  (rho5: _b[L5.ffr]) /// 
  (beta: _b[corecpi_4q]/(1-_b[L.ffr]-_b[L2.ffr]-_b[L3.ffr]-_b[L4.ffr]-_b[L5.ffr])) ///
  (gamma: _b[outputgap_4q]/(1-_b[L.ffr]-_b[L2.ffr]-_b[L3.ffr]-_b[L4.ffr]-_b[L5.ffr])) ///
  (frGap: _b[gap_revision]/(1-_b[L.ffr]-_b[L2.ffr]-_b[L3.ffr]-_b[L4.ffr]-_b[L5.ffr])), post
est2vec table_Min, addto(table_Min) name(col8)
quietly: reg ffr L.ffr L2.ffr L3.ffr L4.ffr L5.ffr corecpi_4q outputgap_4q gap_revision if proxy_time>=1048, robust
matrix table_Min_e[2,6] = e(r2_a)
matrix table_Min_e[3,6] = 5

//  core cpi revision  
reg ffr L.ffr L2.ffr L3.ffr L4.ffr L5.ffr corecpi_4q outputgap_4q corecpi_revision if proxy_time>=1048, robust
estat durbinalt, lags(5) force robust 
matrix table_Min_r[1,7] = r(p)
nlcom (rho1: _b[L.ffr]) (rho2: _b[L2.ffr]) (rho3: _b[L3.ffr]) (rho4: _b[L4.ffr])  (rho5: _b[L5.ffr]) /// 
  (beta: _b[corecpi_4q]/(1-_b[L.ffr]-_b[L2.ffr]-_b[L3.ffr]-_b[L4.ffr]-_b[L5.ffr])) ///
  (gamma: _b[outputgap_4q]/(1-_b[L.ffr]-_b[L2.ffr]-_b[L3.ffr]-_b[L4.ffr]-_b[L5.ffr])) ///
  (frInf: _b[corecpi_revision]/(1-_b[L.ffr]-_b[L2.ffr]-_b[L3.ffr]-_b[L4.ffr]-_b[L5.ffr])), post
est2vec table_Min, addto(table_Min) name(col9)
quietly: reg ffr L.ffr L2.ffr L3.ffr L4.ffr L5.ffr corecpi_4q outputgap_4q gap_revision if proxy_time>=1048, robust
matrix table_Min_e[2,7] = e(r2_a)
matrix table_Min_e[3,7] = 5

// Input to Table 8

est2tex table_Min, preserve replace mark(starb) level(90 95 99) digits(2) fancy path("C:\swp55\Docs\Brookings 2015\Tables") collabels()
  
